/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.base.expr.VWParser;
import java.util.Vector;

public class VWExpression {
    private VWExpression() {
    }

    public static String arrayToString(String[] expressionArray) {
        String expressionString = null;
        if (expressionArray != null) {
            int arraySize = expressionArray.length;
            if (arraySize > 0) {
                expressionString = "{";
                for (int i = 0; i < arraySize; ++i) {
                    if (i > 0) {
                        expressionString = expressionString + ",";
                    }
                    expressionString = expressionString + expressionArray[i];
                }
                expressionString = expressionString + "}";
            } else {
                expressionString = "{}";
            }
        } else {
            expressionString = "{}";
        }
        return expressionString;
    }

    public static String[] stringToArray(String expressionString) {
        Vector<String> expressionList = new Vector<String>();
        Object[] expressionArray = null;
        int nStartIndex = 0;
        int nEndIndex = 0;
        if (expressionString != null) {
            Integer[] delimiterIndexes = VWParser.getArrayDelimiterLocation(expressionString);
            int nIndexSize = delimiterIndexes.length;
            if (nIndexSize == 2) {
                if (delimiterIndexes[0] + 1 != delimiterIndexes[1]) {
                    nStartIndex = delimiterIndexes[0];
                    nEndIndex = delimiterIndexes[1] - 1;
                    expressionList.addElement(expressionString.substring(nStartIndex, nEndIndex));
                }
            } else if (nIndexSize > 2) {
                for (int i = 0; i < nIndexSize - 1; ++i) {
                    nStartIndex = delimiterIndexes[i];
                    nEndIndex = delimiterIndexes[i + 1] - 1;
                    expressionList.addElement(expressionString.substring(nStartIndex, nEndIndex));
                }
            }
            expressionArray = new String[expressionList.size()];
            expressionList.copyInto(expressionArray);
        } else {
            expressionArray = new String[]{};
        }
        return expressionArray;
    }

    public static boolean isServerStyleArrayString(String expressionString) {
        if (expressionString == null || expressionString.length() == 0) {
            return false;
        }
        char[] charArray = expressionString.toCharArray();
        int nStringLen = expressionString.length();
        return nStringLen > 2 && charArray[0] == '{' && charArray[nStringLen - 1] == '}';
    }
}

